// HKCEE 1998 Paper II Qn 2
#include <stdio.h>
#define MAX 8
char GB[MAX][MAX];

// checking for queen(s) from top left to bottom right
int check1 (int R, int C){
	int OK=1;
	while(R>0 && C>0){  // move up to top left as far as possible
		R--; C--;
	}
	while(OK && R<MAX && C<MAX){
		if(GB[R][C]=='Q') OK=0;
		else{
			R++; C++;
		}
	}
	printf("OK1: %d\n",OK);
	return OK;
}

// checking for queen(s) from top right to bottom left
int check2 (int R, int C){
	int OK=1;
	while(R>0 && C<MAX){  // move up to top right as far as possible
		R--; C++;
	}
	while(OK && R<MAX && C>0)
		if(GB[R][C]=='Q') OK=0;
		else{
			R++; C--;
		}
	printf("OK2: %d\n",OK);
	return OK;
}

// checking for queen(s) vertically and horizontally
int check3 (int R, int C){
	int OK=1, i;
	for(i=0;i<MAX;i++)
		if(GB[R][i]=='Q' || GB[i][C]=='Q') OK=0;
	printf("OK3: %d\n",OK);
	return OK;
}

void displayGameBoard(){
	int row,col;
	for(row=0;row<MAX;row++){
		for(col=0;col<MAX;col++)
		    if(GB[row][col]=='Q')
				printf(" Q");
			else
				printf(" -");
		printf("\n");
	}
	printf("\n");
}

void inputRowCol(int *row, int *col){
	do{
		printf("Input row and column of the Queen: ");
		scanf("%d%d", row,col);
	}while(*row<0 || *row>=MAX || *col<0 || *col>=MAX);
}

void initGameBoard(){
	int row, col;
	for(row=0;row<MAX;row++)
		for(col=0;col<MAX;col++)
			GB[row][col]=' ';
}

main(){
	int QC=0, row, col;		// QC = queens' count
	int errs=0, OK1, OK2, OK3;
	displayGameBoard();

	while(!errs && QC<MAX){
		inputRowCol(&row,&col);
		OK1=check1(row,col);
		OK2=check2(row,col);
		OK3=check3(row,col);

		if(OK1 && OK2 && OK3) QC++;
		else errs=1;

		if(!errs) GB[row][col]='Q';
		displayGameBoard();
	}

	if(QC==MAX) printf("You win!\n");
	else printf("You lose!\n");

	system("pause");
	return 0;
}
