/* CE1992 Q2
 Descriptions:
 1. Computer generates 2 random no.s N & F
    where  10<=N<=50  and  0<=F<=1
 2. N is the no.of matches displayed
 3. If F=0, the computer has the first move.
 4. The player and the computer take turns
    in removing M matches away where 0<M<=N/2
 5. The one who has the last match loses
 6. Display N using the following symbols
    * for 10 matches; # for 5 matches; o for 1 match
    eg. 37 is represented by    * * * # o o

 Example: N=21 matches; F=0 computer first
	computer: takes 5 matches  (N/2=10)     N = 16 matches left
	player  : takes 4 matches  (N/2=08)     N = 12 matches left
	computer: takes 6 matches  (N/2=06)     N = 10 matches left
	player  : takes 3 matches  (N/2=05)     N =  7 matches left
	computer: takes 2 matches  (N/2=03)     N =  5 matches left
	player  : takes 2 matches  (N/2=02)     N =  3 matches left
	computer: takes 1 matches  (N/2=01)     N =  2 matches left
	player  : takes 1 matches  (N/2=01)     N =  1 matches left
*/

#include <stdio.h>
#include <time.h>

int N,F,M;
char player[2][10]={"Computer ","Player   "};

void display_matches(){
	int i,k=N;
	printf("no.of matches left :  %2d  ", N);
	for(i=1;i<=k/10;i++) printf("* ");
	k%=10;
	for(i=1;i<=k/5;i++) printf("# ");
	k%=5;
	for(i=1;i<=k;i++) printf("o ");
	printf("\n");
}

void remove_matches(){
	int k=N/2;
	do{
		printf("%s: removes matches [1-%d] :  ", player[F],k);
		scanf("%d",&M);
	}while(M<=0 || M>k);
	N-=M;
}

main(){
	srand(time(NULL));
	N = rand()%42+10;	// total no.of matches }
	F = rand()%2;		// who makes the 1st move }
	display_matches();

	do{
		remove_matches();
		display_matches();
		if(N>1) F=(F+1)%2;
	}while(N>1);

	printf("%s wins !\n",player[F]);
	system("pause");
	return 0;
}
