#include<stdio.h>
#include<string.h>
#include<time.h>
char bd[16];	// board[]

void displayBoard(){
	int i;
	for(i=0;i<16;i++){
		if(i%4==0) printf("\n");
		printf("%c\t",bd[i]);
	}
	puts("");
}

void swapCells(int p1, int p2){		// 洫bd[p1]bd[p2]
	char temp;
	temp = bd[p1];
	bd[p1] = bd[p2];
	bd[p2] = temp;
}

void getMove(int *p1, int *p2){		// 
	int x,y;
	printf("Move x & y: ");
	scanf("%i%i", &x,&y);
	*p1 = x;
	*p2 = y;
}

int isValidMove(int p1, int p2){	// O_Xk
	return (p1>=0 && p1<16 && p2>=0 && p2<16);
}

void finished(){	// 
}

void initBoard(){
	int i;
	for(i=0; i<16; i++)
		bd[rand()%16] = 'A'+i;
}

void initBoard1(){
	int i, r, n[16];
	for(i=0;i<16;i++) n[i]=0;

	for(i=0;i<16;i++){
		do{
			r = rand()%16;
		}while(n[r]!=0);
		n[r] = 1;
		bd[r] = 'A'+i;	// 65+i
	}
}

void initBoard2(){
	int i;
	char ch;
	for(i=0;i<16;i++)
		bd[i] = 'A'+i;	// 65+i
	for(i=0;i<16;i++)
		swapCells(i,rand()%16);
}

int isWin(){
	int i,w=1;
	for(i=0; i<16; i++)
		w = w && (bd[i]==('A'+i));	// (A,B,...)h
	return w;
}

main(){
	int p1,p2;
	srand(time(NULL));
	initBoard();	displayBoard();
	initBoard2();	displayBoard();
	initBoard1();	displayBoard();

	do{
		getMove(&p1,&p2);
		if(isValidMove(p1,p2)){
			swapCells(p1,p2);
			displayBoard();
		}
	}while(!isWin());
	finished();

	system("pause");
	return 0;
}
